/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.crypto;

import com.lowagie.text.pdf.crypto.BlockCipherPadding;
import com.lowagie.text.pdf.crypto.InvalidCipherTextException;

public class PKCS7Padding
implements BlockCipherPadding {
    public String getPaddingName() {
        return "PKCS7";
    }

    public int addPadding(byte[] in, int inOff) {
        byte code = (byte)(in.length - inOff);
        while (inOff < in.length) {
            in[inOff] = code;
            ++inOff;
        }
        return code;
    }

    public int padCount(byte[] in) throws InvalidCipherTextException {
        int count = in[in.length - 1] & 0xFF;
        if (count > in.length) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        for (int i = 1; i <= count; ++i) {
            if (in[in.length - i] == count) continue;
            throw new InvalidCipherTextException("pad block corrupted");
        }
        return count;
    }
}

