/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import java.awt.Point;
import org.pentaho.reporting.libraries.pixie.wmf.MfDcState;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;

public class MfCmdMoveTo
extends MfCmd {
    private static final int RECORD_SIZE = 2;
    private static final int POS_X = 1;
    private static final int POS_Y = 0;
    private int destX;
    private int destY;
    private int scaled_destX;
    private int scaled_destY;

    public void replay(WmfFile file) {
        MfDcState state = file.getCurrentState();
        Point p = this.getScaledDestination();
        state.setCurPos(p.x, p.y);
    }

    public MfCmd getInstance() {
        return new MfCmdMoveTo();
    }

    public int getFunction() {
        return 532;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[MOVE_TO] destination=");
        b.append(this.getDestination());
        return b.toString();
    }

    public void setDestination(int x, int y) {
        this.destX = x;
        this.destY = y;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setDestination(Point p) {
        this.setDestination(p.x, p.y);
    }

    public Point getDestination() {
        return new Point(this.destX, this.destY);
    }

    public Point getScaledDestination() {
        return new Point(this.scaled_destX, this.scaled_destY);
    }

    public void setRecord(MfRecord record) {
        int y = record.getParam(0);
        int x = record.getParam(1);
        this.setDestination(x, y);
    }

    public MfRecord getRecord() {
        Point dest = this.getDestination();
        MfRecord record = new MfRecord(2);
        record.setParam(0, dest.y);
        record.setParam(1, dest.x);
        return record;
    }

    protected void scaleXChanged() {
        this.scaled_destX = this.getScaledX(this.destX);
    }

    protected void scaleYChanged() {
        this.scaled_destY = this.getScaledY(this.destY);
    }
}

