---
title: Kedebideri - Resources
fontversion: 3.001
---

## Requirements

These fonts are supported by all major operating systems (macOS, Windows, Linux-based, iOS, and Android), however the extent of that support depends on the individual OS and application.

## Installation

Install the fonts by decompressing the .zip archive and installing the fonts using the standard font installation process for .ttf (TrueType/OpenType) fonts for your platform. For additional tips see the help page on [Font installation](https://software.sil.org/fonts/installation).

## Keyboarding and character set support

This font package does not include keyboards or other software for entering text. To type the symbols in this font, use the keyboarding systems provided in your OS or use a separate utility. [Keyman](https://keyman.com/) is a cross-platform keyboarding system and one Beria Erfe keyboard is available:

- [Beria Erfe Phonetic](https://keyman.com/keyboards/beria_erfe_phonetic)

Various other means may be available for different operating-system platforms to create additional input methods. Some suggestions are listed here: [Keyboard Systems Overview](https://scriptsource.org/entry/ytr8g8n6sw).

See [Character set support](charset.md) for details of the Unicode characters supported by this font.

## Rendering and application support

These fonts will work normally like any other fonts in most applications. Since the writing system requires special diacritic positioning and kerning, the application/OS will need to support OpenType.

## Web fonts

Web font versions of these fonts (in WOFF and WOFF2 formats) are available in the `web` folder. These can be copied to a web server and used as fonts on web pages. A very basic HTML/CSS demo page is also included. For more information on the options and techniques available for using these fonts on web pages see [Using SIL Fonts on Web Pages](https://software.sil.org/fonts/webfonts).

## Text conversion

Since this script was only recently encoded, people may wish to convert documents from custom encoded fonts to the official Unicode codepoints. TECkit is one program that can be used for character encoding conversion. TECkit allows users to write their own custom conversion mappings. The TECkit package is available for download from SIL’s [TECkit](https://software.sil.org/teckit/) Web site. The [SIL Converters](https://software.sil.org/silconverters/) software will be an important tool in data conversion.

Other suggestions are listed here: [Introduction to Text Conversion and Transliteration](https://scriptsource.org/entry/xlzd6n5aqt).

There is a minimally tested TECKit mapping file available for converting data from the custom encoded Zaghawa Beria font to the Unicode codepoints:

- [ZaghawaBeria2Uni](https://github.com/silnrsi/wsresources/tree/master/scripts/BeriaErfe/legacy/zaghawa-beria/mappings)
